/*
CREATE OR REPLACE FUNCTION prodat_languages.reload_textx(txtno integer) RETURNS varchar
  AS $$
  DECLARE r record;
  BEGIN     
     FOR r IN 
     SELECT t_nr,
            coalesce(CASE _curr_lang
                         WHEN 'D'  THEN coalesce(t_kundtxt0, t_feld0, t_kundtxt0, t_feld0)
                         WHEN 'F'  THEN coalesce(t_kundtxt1, t_feld1, t_kundtxt0, t_feld0)
                         WHEN 'EN' THEN coalesce(t_kundtxt3, t_feld3, t_kundtxt0, t_feld0)
                         WHEN 'IT' THEN coalesce(t_kundtxt4, t_feld4, t_kundtxt0, t_feld0)
                         WHEN 'ES' THEN coalesce(t_kundtxt5, t_feld5, t_kundtxt0, t_feld0)
                         WHEN 'CZ' THEN coalesce(t_kundtxt6, t_feld6, t_kundtxt0, t_feld0)
                         WHEN 'RU' THEN coalesce(t_kundtxt7, t_feld7, t_kundtxt0, t_feld0)
                    ELSE
                         coalesce(t_kundtxt0, t_feld0)
                    END
                    ,
                    'xtt'::char(5) || t_nr
                   )
              AS curr_lang
             ,
             coalesce(t_kundtxt0, t_feld0, t_kundtxt0, t_feld0, 'xtt'::char(5) || t_nr) AS D,
             coalesce(t_kundtxt1, t_feld1, t_kundtxt0, t_feld0, 'xtt'::char(5) || t_nr) AS F,
             coalesce(t_kundtxt3, t_feld3, t_kundtxt0, t_feld0, 'xtt'::char(5) || t_nr) AS EN,
             coalesce(t_kundtxt4, t_feld4, t_kundtxt0, t_feld0, 'xtt'::char(5) || t_nr) AS IT,
             coalesce(t_kundtxt5, t_feld5, t_kundtxt0, t_feld0, 'xtt'::char(5) || t_nr) AS ES,
             coalesce(t_kundtxt6, t_feld6, t_kundtxt0, t_feld0, 'xtt'::char(5) || t_nr) AS CZ,
             coalesce(t_kundtxt7, t_feld7, t_kundtxt0, t_feld0, 'xtt'::char(5) || t_nr) AS RU                  
       FROM public.text0

       LEFT JOIN LATERAL (SELECT s_inha FROM public.settings WHERE s_vari = 'curr_lang:' || TSystem.current_user() ) AS user_lang ON true
       LEFT JOIN LATERAL (SELECT s_inha FROM public.settings WHERE s_vari = 'Lang') AS main_lang ON true
  
       LEFT JOIN LATERAL (SELECT coalesce((SELECT s_spr_key FROM adkspco WHERE s_spco = user_lang.s_inha),
                                             main_lang.s_inha
                                            ) AS _curr_lang
                            ) AS lang ON true
     WHERE txtno IS null OR t_nr = txtno
     ORDER BY t_nr
     LOOP
       --RAISE NOTICE 'reload_textx:%', r.t_nr;
     INSERT INTO textx_current (txc_nr, txc_spco, txc_text) VALUES (r.t_nr, -1, r.curr_lang);
     INSERT INTO textx_current (txc_nr, txc_spco, txc_text) VALUES (r.t_nr,  0, r.D);
     INSERT INTO textx_current (txc_nr, txc_spco, txc_text) VALUES (r.t_nr,  1, r.F);
     INSERT INTO textx_current (txc_nr, txc_spco, txc_text) VALUES (r.t_nr,  3, r.EN);
     INSERT INTO textx_current (txc_nr, txc_spco, txc_text) VALUES (r.t_nr,  4, r.IT);
     INSERT INTO textx_current (txc_nr, txc_spco, txc_text) VALUES (r.t_nr,  5, r.ES);
     INSERT INTO textx_current (txc_nr, txc_spco, txc_text) VALUES (r.t_nr,  6, r.CZ);
     INSERT INTO textx_current (txc_nr, txc_spco, txc_text) VALUES (r.t_nr,  7, r.RU);
     --  
     PERFORM set_config('xtt.X.' || r.t_nr, r.curr_lang, false);
       PERFORM set_config('xtt.0.' || r.t_nr, r.D, false);
       PERFORM set_config('xtt.1.' || r.t_nr, r.F, false);
       PERFORM set_config('xtt.3.' || r.t_nr, r.EN, false);
       PERFORM set_config('xtt.4.' || r.t_nr, r.IT, false);
       PERFORM set_config('xtt.5.' || r.t_nr, r.ES, false);
       PERFORM set_config('xtt.6.' || r.t_nr, r.CZ, false);
       PERFORM set_config('xtt.7.' || r.t_nr, r.RU, false);
     -- 
     END LOOP;
   
   IF txtno IS null THEN         
      RETURN null;
   ELSE
      RETURN null;
   END IF;
   
  END $$ LANGUAGE plpgsql;
  
SELECT prodat_languages.reload_textx(null);
*/

-- aktuelle Sprache

CREATE OR REPLACE FUNCTION prodat_languages.curr_lang() RETURNS varchar AS $$
  SELECT s_inha FROM public.settings WHERE s_vari = 'Lang';
  $$ LANGUAGE sql STABLE PARALLEL SAFE;

CREATE OR REPLACE FUNCTION prodat_languages.current_lang() RETURNS varchar AS $$
  SELECT prodat_languages.curr_lang();
  $$ LANGUAGE sql STABLE PARALLEL SAFE;

CREATE OR REPLACE FUNCTION prodat_languages.currlang() RETURNS varchar AS $$
  SELECT prodat_languages.curr_lang();
  $$ LANGUAGE sql STABLE PARALLEL SAFE;

-- Sprache pro Nutzer, wird über bei jedem Dokumentdruck Nutzerspezifisch abgelegt #4924
CREATE OR REPLACE FUNCTION prodat_languages.ReportLang_current() RETURNS varchar AS $$
  SELECT s_inha FROM settings WHERE s_vari = 'ReportLang_' || TSystem.current_user();
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
--


-- function die einem den Inhalt aus der text0 zurück gibt
/*
CREATE OR REPLACE FUNCTION prodat_languages.lang_text(integer, spco integer) RETURNS varchar 
  AS $$
     SELECT coalesce(current_setting('xtt.' || spco || '.' || $1, true),
                     prodat_languages.reload_textx($1)
                     );
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
*/

CREATE OR REPLACE FUNCTION prodat_languages.lang_text(integer, spco integer) RETURNS varchar AS $$
  DECLARE i integer;
          --spco INTEGER;
          r varchar;
  BEGIN
    i := TSystem.Settings__GetInteger('LangMenu:' || current_user);
    --spco:= s_spco FROM adkspco WHERE s_spr_key=$2;
    PERFORM TSystem.Settings__Set('LangMenu:' || current_user, spco);

    r := prodat_languages.lang_text($1);

    PERFORM TSystem.Settings__Set('LangMenu:' || current_user, i);

    RETURN r;
  -- ist "parallel unsafe" und "volatile", da der Wert des Settings "'LangMenu:' || current_user" hin und her geändert wird (#21507)
  END $$ LANGUAGE plpgsql;
--

--

-- Mehrsprachigkeit unterstützt nach Ersetzung der Sessionfunktion "CURRENT_USER" gegen eigene Funktion "TSystem.current_user()" wieder schneller.
/*
CREATE OR REPLACE FUNCTION prodat_languages.lang_text(integer) RETURNS varchar
  AS $$
     SELECT coalesce(current_setting('xtt.curr_lang.' || $1, true),
                     prodat_languages.reload_textx($1)
                     );

  $$ LANGUAGE sql STABLE;

CREATE OR REPLACE FUNCTION prodat_languages.lang_text(integer) RETURNS varchar
  AS $$
     SELECT txc_text FROM textx_current WHERE txc_nr = $1 AND txc_spco = -1
  $$ LANGUAGE sql STABLE PARALLEL SAFE;  
*/

CREATE OR REPLACE FUNCTION prodat_languages.lang_text(integer) RETURNS varchar
  AS $$
     --WITH bringt nix, langsamer
     SELECT
            coalesce(CASE _curr_lang
                          WHEN 'D'  THEN coalesce(t_kundtxt0, t_feld0, t_kundtxt0, t_feld0)
                          WHEN 'F'  THEN coalesce(t_kundtxt1, t_feld1, t_kundtxt0, t_feld0)
                          WHEN 'EN' THEN coalesce(t_kundtxt3, t_feld3, t_kundtxt0, t_feld0)
                          WHEN 'IT' THEN coalesce(t_kundtxt4, t_feld4, t_kundtxt0, t_feld0)
                          WHEN 'ES' THEN coalesce(t_kundtxt5, t_feld5, t_kundtxt0, t_feld0)
                          WHEN 'CZ' THEN coalesce(t_kundtxt6, t_feld6, t_kundtxt0, t_feld0)
                          WHEN 'RU' THEN coalesce(t_kundtxt7, t_feld7, t_kundtxt0, t_feld0)
                     ELSE
                          coalesce(t_kundtxt0, t_feld0)
                     END
                     ,
                     'xtt'::char(5) || $1
            )
       FROM public.text0
     LEFT JOIN LATERAL (SELECT s_inha FROM public.settings WHERE s_vari = 'curr_lang:' || TSystem.current_user() ) AS user_lang ON true
     LEFT JOIN LATERAL (SELECT s_inha FROM public.settings WHERE s_vari = 'Lang') AS main_lang ON true

     LEFT JOIN LATERAL (SELECT coalesce((SELECT s_spr_key FROM adkspco WHERE s_spco = user_lang.s_inha),
                                           main_lang.s_inha
                                          ) AS _curr_lang
                          ) AS lang ON true

     WHERE t_nr = $1;

  $$ LANGUAGE sql STABLE PARALLEL SAFE;

/* Schnelle Funktion gezielt bei Kunden mit großen Daten bis final gelöst
CREATE OR REPLACE FUNCTION prodat_languages.lang_text(integer) RETURNS varchar
  AS $$
     SELECT coalesce(t_kundtxt0, t_feld0)
       FROM public.text0
      WHERE t_nr = $1;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
--*/

--
CREATE OR REPLACE FUNCTION prodat_languages.langtext(integer) RETURNS varchar AS $$
    SELECT prodat_languages.lang_text($1);
    $$ LANGUAGE sql STABLE PARALLEL SAFE;
--

--Z_99_Deprecated
CREATE OR REPLACE FUNCTION Z_99_Deprecated.lang_text(integer) RETURNS varchar AS $$
    SELECT prodat_languages.lang_text($1);
    $$ LANGUAGE sql STABLE PARALLEL SAFE;

CREATE OR REPLACE FUNCTION Z_99_Deprecated.langtext(integer) RETURNS varchar AS $$
    SELECT prodat_languages.lang_text($1);
    $$ LANGUAGE sql STABLE PARALLEL SAFE;

CREATE OR REPLACE FUNCTION Z_99_Deprecated.lang_text(integer, spco integer) RETURNS varchar  AS $$
    SELECT prodat_languages.lang_text($1, $2);
    $$ LANGUAGE sql STABLE PARALLEL SAFE;
--

--
CREATE OR REPLACE FUNCTION prodat_languages.lang_land(iso varchar, lang varchar DEFAULT prodat_languages.curr_lang()) RETURNS varchar(50) AS $$
  DECLARE result varchar;
  BEGIN
    SELECT ll_land INTO result FROM laenderlang WHERE ll_iso = iso AND ll_spr_key = lang;

    IF result IS NULL THEN
       SELECT ll_land INTO result FROM laenderlang WHERE ll_iso = iso AND ll_spr_key = prodat_languages.curr_lang();
    END IF;

    IF result IS NULL THEN
       SELECT l_land INTO result FROM laender WHERE l_iso = iso;
    END IF;

    IF result IS NULL THEN
       result := iso;
    END IF;

    RETURN result;
  END $$ LANGUAGE plpgsql STABLE;

--- #20269 Funktion ersetzt xtt in der Messages
CREATE OR REPLACE FUNCTION prodat_languages.lang_text__replace_xtt( IN _text varchar ) RETURNS varchar AS $$
  DECLARE
      result varchar := _text;
      rec    record;
  BEGIN

    WHILE EXISTS( SELECT DISTINCT unnest(regexp_matches(result, E'[[:<:]]xtt(\\\d*)[[:>:]]', 'g'))::integer ) LOOP  --- so lange trinn bleiben, bis alle xtt übersetzt sind
         --- rausfischt xtt's-Nummer. Ergebniss -> Recordset
         FOR rec IN SELECT DISTINCT unnest(regexp_matches(result, E'[[:<:]]xtt(\\\d*)[[:>:]]', 'g'))::integer AS xtts LOOP

             result := replace( result, 'xtt' || rec.xtts, lang_text( rec.xtts ) );
             --- raise notice 'rec.xtts = %, result = %', rec.xtts, result;
         END LOOP;
    END LOOP;
    RETURN result;
  END $$ LANGUAGE plpgsql STABLE PARALLEL SAFE;
